##탑승 클래스별 생존자와 사망자의 수치를 시각화로 표현
##시각화 bar, plot, pie, scatter, violinplot, boxplot을 순서대로 표현 

import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns


######################## 한글 폰트 깨짐 방지 
from matplotlib import font_manager, rc

font_path = "c:\\windows\\fonts\\malgun.ttf"
font_name = font_manager.FontProperties(fname=font_path).get_name()
rc('font', family=font_name)
#############################################################################



plt.figure(figsize=(18, 20)) ## 차트 크기(단위는 인치로 계산됨)


######################## data 분석 자료. 탑승 클래스(1,2,3등급) 별 생존자와 사망자 수 분석 자료 
df = pd.read_csv('../data/titanic.csv', encoding='euc-kr')

df_pclass11 = df[(df.Survived == 1) & (df.Pclass == 1)].count()
df_pclass12 = df[(df.Survived == 1) & (df.Pclass == 2)].count()
df_pclass13 = df[(df.Survived == 1) & (df.Pclass == 3)].count()

df_pclass01 = df[(df.Survived == 0) & (df.Pclass == 1)].count()
df_pclass02 = df[(df.Survived == 0) & (df.Pclass == 2)].count()
df_pclass03 = df[(df.Survived == 0) & (df.Pclass == 3)].count()

x1 = ['first', 'second', 'third']  ## x축이름 리스트 

survived_df = [df_pclass11.Pclass, df_pclass12.Pclass, df_pclass13.Pclass]
dead_df = [df_pclass01.Pclass, df_pclass02.Pclass, df_pclass03.Pclass]
###############################################################################



######################## 탑승 클래스 별 생존자와 사망자를 두 개의 바 bar를 한번에 표시 
plt.subplot(231)
index = np.arange(len(x1))
bar_width = 0.2

plt.bar(index, survived_df, bar_width, label='Survived', alpha=0.3)  ##(세로로 그리기)
plt.bar(index+bar_width, dead_df, bar_width, label='Dead',  alpha=0.3)  ##(세로로 그리기)
plt.xticks(index, x1) ##(세로로 그리기)
plt.xlabel('탑승클래스')  ##x축 이름 
h=plt.ylabel('인\n원') ##y축 이름
h.set_rotation(0)
plt.title('탑승클래스별 생존자와 사망자')

#plt.barh(index, survived_df, bar_width, label='Survived', alpha=0.3)  ##(가로로 그리기)
#plt.barh(index+bar_width, dead_df, bar_width, label='Dead', alpha=0.3)  ##(가로로 그리기)
#plt.xticks(range(0,400,50)) ##(가로로 그리기)
#plt.yticks(index, x1)

plt.legend()
############################################################################



######################## 탑승 클래스 별 생존자와 사망자를 plot으로 표현하기 
plt.subplot(232)
plt.plot(x1, survived_df, color='green', linestyle='dotted', marker='o', label='survived')
plt.plot(x1, dead_df, color='orange', marker='s', label='dead')
plt.title('탑승클래스별 생존자와 사망자')  ##차트제목 
plt.xlabel('탑승클래스')  ##x축 이름 
h=plt.ylabel('인\n원') ##y축 이름
h.set_rotation(0) 
plt.legend()
###########################################################################




######################## pie

pieColor=['pink','lightgreen','lightblue']
plt.subplot(233)
plt.pie(survived_df, autopct='%1.1f%%', radius=1.2, startangle=90, colors=pieColor,shadow=True,
        wedgeprops={'edgecolor':'k','linewidth': 0.5, 'linestyle': 'solid', 'antialiased': True})
plt.pie(dead_df, autopct='%1.1f%%', radius=0.6, startangle=90, colors=pieColor, shadow=True,
        wedgeprops={'edgecolor':'k','linewidth': 0.5, 'linestyle': 'solid', 'antialiased': True})
plt.legend(x1, loc='upper right')
plt.title('탑승클래스별 생존자와 사망자')
###########################################################################



######################## 산포도 scatter  [탑승자 별 나이]
plt.subplot(234)
plt.scatter(df.Fare, df.Age, alpha=0.3, s=1*df.Age, c=df.Age, cmap='plasma_r')
plt.title('운임비 별 나이 분포')  ##차트제목 
plt.xlabel('운임비')  ##x축 이름 
h=plt.ylabel('나\n이') ##y축 이름
h.set_rotation(0)
###########################################################################




######################## violinplot [탑승클래스별 생존자와 사망자  나이 분포], [성별 생존자와 사망자 나이 분포]
plt.subplot(235)
sns.violinplot('Pclass', 'Age', hue='Survived', data=df, scale='count', split=True, palette='RdBu')  ##'OrRd'
plt.title('탑승클래스 별 나이 분포')  ##차트제목
plt.xlabel('탑승클래스')  ##x축 이름 
h=plt.ylabel('나\n이') ##y축 이름
h.set_rotation(0)
###########################################################################


######################## boxplot [탑승클래스별 생존자와 사망자  나이 분포]
plt.subplot(236)
sns.boxplot('Pclass', 'Age', hue='Survived', data=df, width=0.5, palette='Set3')
plt.title('운임비에 따른 나이 분포')  ##차트제목 
plt.legend(loc='upper right')
plt.title('탑승클래스 별 나이 분포')  ##차트제목
plt.xlabel('탑승클래스')  ##x축 이름 
h=plt.ylabel('나\n이') ##y축 이름
h.set_rotation(0)

##########################################################################


plt.show()  ##차트 그리기 
##########################################################################end
